﻿using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Data.SqlClient;
using System.Reflection;
using System.Data;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRFileManager : AHOBPRBaseBO 
    {
        private AHOBPRShared _sharedManager = new AHOBPRShared();

        #region Get File
        /// <summary>
        /// Get PDF file
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public byte[] GetFile(string fileId, string fileType)
        {
            byte[] fileContent = null;

            try
            {
                using (AHOBPRLinqDataContext db = GetDataContext())
                {
                    //call stored procedure
                    IList<SP_GetRegistrantFileResult> results = db.SP_GetRegistrantFile(fileType, fileId).ToList();
                    if (results != null)
                    {
                        if (results.Count > 0)
                        {
                            fileContent = (byte[])results.FirstOrDefault().FILE_CONTENT.ToArray();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            }

            return fileContent;
        }


        #endregion

        #region Save File
        /// <summary>
        /// Save PDF File
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="pdfStream"></param>
        /// <returns></returns>
        public bool SaveFile(string fileId, string fileType, Stream fileStream)
        {
            bool result = false;
            string dateTime = DateTime.Now.ToString();

            byte[] data = ReadStream(fileStream);

            try
            {
                using (AHOBPRLinqDataContext db = GetDataContext())
                {
                    //call stored procedure
                    int results = db.SP_InsertRegistrantFile(fileId, fileType, data, "RESTful Service");

                    result = true;
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            }

            return result;
        }

        public static byte[] ReadStream(Stream input)
        {
            byte[] buffer = new byte[16 * 1024];
            using (MemoryStream ms = new MemoryStream())
            {
                int read;
                while ((read = input.Read(buffer, 0, buffer.Length)) > 0)
                {
                    ms.Write(buffer, 0, read);
                }
                return ms.ToArray();
            }
        }
        #endregion

        #region Delete File
        public bool DeleteFile(string id, string type)
        {
            bool result = true;

            try
            {
                using (AHOBPRLinqDataContext db = GetDataContext())
                {
                    //call stored procedure
                    int results = db.SP_DeleteRegistrantFile(type, id);

                    result = true;
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            }

            return result;
        }
        #endregion

        #region Get a list of registrants who have PDFs filtered by questionnaire completed date range

        /// <summary>
        /// Get a list of registrants who have PDFs filtered by questionnaire completed date range
        /// </summary>
        /// <param name="startdate"></param>
        /// <param name="enddate"></param>
        /// <returns></returns>
        public List<string> PdfRegistrantList(string startdate, string enddate)
        {
            List<string> userIds = null;

            if (startdate.Length == 8 && enddate.Length == 8)
            {
                DateTime startDateTime = DateTime.MinValue;
                DateTime endDateTime = DateTime.MinValue;
                try
                {
                    startDateTime = Convert.ToDateTime(startdate.Substring(4, 2) + "/" + startdate.Substring(6, 2) + "/" + startdate.Substring(0, 4));
                    endDateTime = Convert.ToDateTime(enddate.Substring(4, 2) + "/" + enddate.Substring(6, 2) + "/" + enddate.Substring(0, 4));

                    if (startDateTime != DateTime.MinValue && endDateTime != DateTime.MinValue)
                    {
                        using (_dbAhobpr = GetDataContext())
                        {
                            userIds = (from e in _dbAhobpr.FORM_RESPONSE_STATUS
                                             where e.QUESTIONNAIRE_COMPLETED_DATE >= startDateTime
                                               && e.QUESTIONNAIRE_COMPLETED_DATE < endDateTime.AddDays(1)
                                             select e.FORM_RESPONSE.REGISTRANT.USER_ID.ToString()).ToList();

                            if (userIds.Count > 0)
                            {
                                // only get the ones with PDF records
                                userIds = (from e in _dbAhobpr.REGISTRANT_FILEs
                                           where e.FILE_TYPE == "responsePdf"
                                              && userIds.Contains(e.FILE_ID)
                                           select e.FILE_ID).ToList();
                            }
                        }
                    }
                    else
                    {
                        _sharedManager.LogErrorMessage("PDF Utility", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, 
                            "Invalid start date (" + startdate + ") or end date (" + enddate + ").");
                    }
                }
                catch (Exception ex)
                {
                    _sharedManager.LogErrorMessage("PDF Utility", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                }

            }

            return userIds;
        }

        #endregion

        #region Get PDF file Meta Data
        /// <summary>
        /// Get PDF file meta data
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public string GetPdfMetaData(string userId)
        {
            string metaData = string.Empty;

            try
            {
                using (AHOBPRLinqDataContext db = GetDataContext())
                {
                    //call stored procedure
                    metaData = db.SP_GetPdfMetaData(userId).FirstOrDefault().META_DATA;
                    if (string.IsNullOrEmpty(metaData))
                        metaData = string.Empty;
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            }

            return metaData;
        }


        #endregion

        #region Get PDF Last Run Date
        /// <summary>
        /// Get PDF file meta data
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public string GetLastPdfRunDate()
        {
            string metaData = string.Empty;

            try
            {
                using (AHOBPRLinqDataContext db = GetDataContext())
                {
                    //call stored procedure
                    metaData = db.SP_GetMaxPdfCreatedDate().FirstOrDefault().LAST_RUN_DATE_TIME.ToString();
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            }

            return metaData;
        }


        #endregion
    }
}
